implementation module windowdispose


//	Clean Object I/O library, version 1.1


import	StdBool, StdList, StdMisc, StdTuple
import	oswindow
import	iostate, receiverid, windowaccess, windowclipstate


windowdisposeFatalError :: String String -> .x
windowdisposeFatalError function error
	= FatalError function "windowdispose" error


/*	disposeWindow disposes all system resources associated with the indicated window if it exists.
	Inactive modal dialogues are not removed.
	It removes the indicated window from the window device administration.
*/
disposeWindow :: !WID !(IOSt .l .p) -> IOSt .l .p
disposeWindow wid ioState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice ioState
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow wid windows
	// The window could not be found
	| not found
		= IOStSetDevice (WindowSystemState windows) ioState
	# (wids, wsH)			= getWindowStateHandleWIDS wsH
	# (wMode,wsH)			= getWindowStateHandleWindowMode wsH
	// Any modeless window can be disposed
	| wMode<>Modal
		= dispose wids wsH windows ioState
	# (_,activeId,windows)	= getWindowHandlesActiveWindow windows
	// Do not dispose inactive modal windows
	| wids.wId<>activeId.wId
		= IOStSetDevice (WindowSystemState (setWindowHandlesWindow wsH windows)) ioState
	// Dispose only the active modal window
		= dispose wids wsH windows ioState
where
	dispose :: !WIDS !(WindowStateHandle (PSt .l .p)) !(WindowHandles (PSt .l .p)) !(IOSt .l .p) -> IOSt .l .p
	dispose wids=:{wId} wsH windows ioState
		# (_,_,windows)		= removeWindowHandlesWindow (toWID wId) windows
		# windows			= recycleWindowId wId windows
		# (rids,ioState)	= accIOToolbox (disposeWindowStateHandle wsH) ioState
		# ioState			= unbindRIds rids ioState		// When timers are part of windows, also unbind timers
		= IOStSetDevice (WindowSystemState windows) ioState
	where
		recycleWindowId :: !Id !(WindowHandles .ps) -> WindowHandles .ps
		recycleWindowId id windows
			| isSysId id
			= {windows & whsIds=[fromId id:windows.whsIds]}
			= windows


/*	disposeCursorInfo disposes all system resources associated with the given CursorInfo.
	PA: not yet implemented

disposeCursorInfo :: !CursorInfo !(IOSt .l .p) -> IOSt .l .p
*/


/*	disposeWindowStateHandle disposes all system resources associated with the given WindowStateHandle.
	The return [Id] are the Ids of receivers that should become unbound.
	When timers are part of windows, also timer ids should be returned.
*/
disposeWindowStateHandle :: !(WindowStateHandle .ps) !*OSToolbox -> (![Id],!*OSToolbox)
disposeWindowStateHandle {wshIds={wPtr},wshHandle=Just wsH} tb
	#	wH					= wsH.wlsHandle
	#	(hasWindowInfo,info)= case wH.whWindowInfo of
								(Just info)	-> (True, info)
								_			-> (False,undef)
	#	(rIdss,tb)			= StateMap disposeWElementHandle wH.whItems tb
	#	(_,_,  tb)			= OSdestroyWindow (wH.whMode==Modal) wPtr tb
		rids				= flatten rIdss
	|	not hasWindowInfo
		=	(rids,tb)
	|	otherwise
		=	(rids,disposeClipState info.windowClip tb)
disposeWindowStateHandle _ _
	=	windowdisposeFatalError "disposeWindowStateHandle" "window expected instead of placeholder"


/*	disposeWElementHandle (recursively) disposes all system resources associated with the given 
	WElementHandle. 
	It returns all freed receiver ids.
	When timers are part of windows, also timer ids should be returned.
*/
disposeWElementHandle :: !(WElementHandle .ls .ps) !*OSToolbox -> (![Id],!*OSToolbox)
disposeWElementHandle (WListLSHandle itemHs) tb
	# (ridss,tb)	= StateMap disposeWElementHandle itemHs tb
	= (flatten ridss,tb)
disposeWElementHandle (WExtendLSHandle {wExtendItems=itemHs}) tb
	# (ridss,tb)	= StateMap disposeWElementHandle itemHs tb
	= (flatten ridss,tb)
disposeWElementHandle (WChangeLSHandle {wChangeItems=itemHs}) tb
	# (ridss,tb)	= StateMap disposeWElementHandle itemHs tb
	= (flatten ridss,tb)
disposeWElementHandle (WItemHandle itemH) tb
	= disposeWItemHandle itemH tb


/*	disposeWItemHandle (recursively) disposes all system resources associated with the given WItemHandle. 
	It returns all freed receiver ids.
	When timers are part of windows, also timer ids should be returned.
*/
disposeWItemHandle :: !(WItemHandle .ls .ps) !*OSToolbox -> (![Id],!*OSToolbox)
disposeWItemHandle itemH=:{wItemKind=IsRadioControl} tb
	# radioInfo	= getWItemRadioInfo itemH.wItemInfo
	= ([],StateMap2 (\{radioItemPtr}->OSdestroyRadioControl radioItemPtr) radioInfo.radioItems tb)
disposeWItemHandle itemH=:{wItemKind=IsCheckControl} tb
	# checkInfo	= getWItemCheckInfo itemH.wItemInfo
	= ([],StateMap2 (\{checkItemPtr}->OSdestroyCheckControl checkItemPtr) checkInfo.checkItems tb)
disposeWItemHandle itemH=:{wItemKind=IsPopUpControl} tb
	= ([],OSdestroyPopUpControl itemH.wItemPtr tb)
disposeWItemHandle itemH=:{wItemKind=IsSliderControl} tb
	= ([],OSdestroySliderControl itemH.wItemPtr tb)
disposeWItemHandle itemH=:{wItemKind=IsTextControl} tb
	= ([],OSdestroyTextControl itemH.wItemPtr tb)
disposeWItemHandle itemH=:{wItemKind=IsEditControl} tb
	= ([],OSdestroyEditControl itemH.wItemPtr tb)
disposeWItemHandle itemH=:{wItemKind=IsButtonControl} tb
	= ([],OSdestroyButtonControl itemH.wItemPtr tb)
disposeWItemHandle itemH=:{wItemKind=IsCustomButtonControl} tb
	= ([],OSdestroyCustomButtonControl itemH.wItemPtr tb)
disposeWItemHandle itemH=:{wItemKind=IsCustomControl} tb
	= ([],OSdestroyCustomControl itemH.wItemPtr tb)
disposeWItemHandle itemH=:{wItemKind=IsCompoundControl} tb
	# (rIdss,tb)	= StateMap disposeWElementHandle itemH.wItems tb
	# tb			= OSdestroyCompoundControl itemH.wItemPtr tb
	  rids			= flatten rIdss
	  info			= getWItemCompoundInfo itemH.wItemInfo
	| isNothing info.compoundLookInfo
	= (rids,tb)
	= (rids,disposeClipState (fromJust info.compoundLookInfo).compoundClip tb)
disposeWItemHandle itemH=:{wItemKind=IsOtherControl controltype} tb
//	The control is a receiver:
	| controltype=="Receiver" || controltype=="Receiver2"
	= ([fromJust itemH.wItemId],tb)
//	The control is a timer:
//	| controltype=="TimerControl"
//	= ([],getTimerLoc itemH,tb)
	= windowdisposeFatalError "disposeWItemHandle" ("unknown control type: "+++controltype)
